program define figure5_dynan

* create bar charts showing how mortgage distress changed for different groups

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/figure5_dynan_$mydate, replace
  set more off

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
*  drop if _n > 30000
  
  save tempdat, replace

* create the groups of interest

* people who are in the sample every wave from 2005-2009, not retired, homeowners
* high D/A for boom states and non-boom states separately

  quietly gen temp1 = (wgt>=0 & wgt~=.)
  quietly gen temp4 = ((temp1 + l2.temp1 + l4.temp1) == 3)
  quietly replace temp4 = 0 if yr ~= 2009
  by persid:  egen cons_samp = max(temp4)
  drop temp*

  quietly gen temp1 = reth
  quietly replace temp1 = 0 if yr~=2009 | temp1==.
  by persid:  egen retsamp = max(temp1)
  drop temp1
  
  quietly gen temp1 = homeown
  quietly replace temp1 = 0 if yr~=2007 | temp1==.
  by persid:  egen hosamp = max(temp1)
  drop temp1 

  keep if cons_samp==1
  keep if retsamp==0
  keep if hosamp==1
  drop if yr < 2007
  
  quietly gen temp1 = hboom6
  quietly replace temp1 = 0 if hboom6==. 
  by persid:  egen boomsamp = max(temp1)
  drop temp1

  quietly gen group1 = boomsamp==0
  quietly gen group2 = boomsamp==1

  *count if group1 == 1 & yr == 2007
  *count if group2 == 1 & yr == 2007

  foreach ggg in group1 group2 {
             quietly _pctile mort_to_hv if yr == 2007 & `ggg'==1 [w=wgt], percentiles(80)
             quietly gen tq`ggg' = (mort_to_hv >= r(r1)) if yr == 2007 & `ggg'==1 & mort_to_hv~=.
             quietly gen oh`ggg' = (mort_to_hv < r(r1)) if yr == 2007 & `ggg'==1 & mort_to_hv~=.
           }
  count if l2.tqgroup1==1 & yr==2009
  count if l2.tqgroup2==1 & yr==2009
  count if l2.ohgroup1==1 & yr==2009
  count if l2.ohgroup2==1 & yr==2009

  quietly gen hi_d = 1 if tqgroup1==1 | tqgroup2==1 | l2.tqgroup1==1 | l2.tqgroup2==1 ///
                | l4.tqgroup1==1 | l4.tqgroup2==1
  quietly replace hi_d = 2 if ohgroup1==1 | ohgroup2==1 | l2.ohgroup1==1 | l2.ohgroup2==1 ///
                | l4.ohgroup1==1 | l4.ohgroup2==1
  tab hi_d
  drop if hi_d==.
  count if hi_d == 1 & boomsamp==0 & yr==2009

* mortgage distress variables

  quietly gen dist_v_likely = mort_dist_prob_1==1 | mort_dist_prob_2==1 ///
                            if mort_dist_prob_1~=. & mort_dist_prob_2~=.

  quietly gen dist_s_likely = mort_dist_prob_1==3 | mort_dist_prob_2==3 ///
                            if mort_dist_prob_1~=. & mort_dist_prob_2~=.

  foreach vvv in mort_beh_yes mort_fc_yes mort_mod {
    forvalues nnn = 1/2 {
      quietly replace `vvv'_`nnn' = (`vvv'_`nnn'==1) if `vvv'_`nnn'~=.
    }
  }

  quietly gen mort_beh_yes = mort_beh_yes_1 == 1 | mort_beh_yes_2 == 1
  quietly gen mort_fc_yes  = mort_fc_yes_1 == 1 | mort_fc_yes_2 == 1
  quietly gen mort_mod     = mort_mod_1 == 1 | mort_mod_2 == 1
  
* indicator of someone who exited homeownership since 2007

  quietly gen exit_ho_post07 = (homeown==0) & (l2.homeown==1)
  quietly replace exit_ho_post07 = (homeown==0) & (l4.homeown==1) if yr==2011

* indicator of someone who has moved since 2007

  quietly gen moved_post07 = moved_yes
  quietly replace moved_post07 = (moved_yes==1) | (l2.moved_yes==1) if yr==2011

* collapse the data

  sort boomsamp hi_d yr  
  collapse (mean) mort_beh_yes ///
                  mort_fc_yes ///
				  dist_v_likely ///
				  dist_s_likely ///
				  moved_post07 ///
				  exit_ho_post07 ///
                  (count) nnn=mort_beh_yes ///
                  [w=wgt], by(boomsamp hi_d yr)

  drop if yr==2007
  label define hdlab 1 "High Leverage" 2 "Others"
  label values hi_d hdlab
  label define boomlab 0 "Non-boom States" 1 "Boom States"
  label values boomsamp boomlab
  
* graph
				  	
  local t1 "Behind on Mortgage Payments"
  local t2 "Behind on Payments and Foreclosure Started"
  local t3 "Very Likely to Fall Behind"
  local t4 "Somewhat Likely to Fall Behind"
  local t5 "Moved Since 2007"
  local t6 "No Longer a Homeowner"
  
  local nnn = 1
  foreach vvv in mort_beh_yes mort_fc_yes dist_v_likely dist_s_likely moved_post07 exit_ho_post07 {
    graph bar (mean) `vvv', ///
       over(yr) over(hi_d) over(boomsamp) ///
	   ytitle("Fraction of 2007 Homeowners") ///
         title("`t`nnn''", color(black) size(xlarge)) ///
         graphregion(margin(vsmall) color(white)) bgcolor(white) /// 
         bar(1, color(ltblue)) bar(2, color(edkblue)) ///
         legend(region(lcolor(white))) ///
	   yscale(range(0 .40)) ylabel(0(.1).4,grid)
      graph save graphs/bar_`vvv', replace
      graph export graphs/bar_`vvv'.emf, replace
      local nnn = `nnn' + 1
  }
  
capture log close

end
